<?php
// index.php
require_once('../includes/config.php');
include('../includes/db.php');

// Check if PDF generation is requested
if (isset($_GET['action']) && $_GET['action'] == 'generate_pdf') {
    $unique_id = $_GET['uniqueid'] ?? '';
    $apostille = null;
    
    if (!empty($unique_id)) {
        $sql = "SELECT a.*, u.name as user_name FROM apostille_log a 
                LEFT JOIN users u ON a.user = u.email 
                WHERE a.unique_id = ? AND a.status = 'active'";
        
        $stmt = mysqli_prepare($link, $sql);
        if ($stmt) {
            mysqli_stmt_bind_param($stmt, "s", $unique_id);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);
            
            if ($result && mysqli_num_rows($result) > 0) {
                $apostille = mysqli_fetch_assoc($result);
            }
            mysqli_stmt_close($stmt);
        }
    }
    
    if (!$apostille) {
        die('Error: E-Apostille not found or inactive.');
    }
    
    // PDF তৈরি করার জন্য HTML দিয়ে শুরু করুন
    $html = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 20px;
            }
            .container {
                max-width: 210mm;
                height: 297mm;
                border: 1px solid #000;
                padding: 15mm;
                position: relative;
                background: white;
            }
            .title {
                text-align: center;
                font-size: 24px;
                font-weight: bold;
                margin: 10px 0;
            }
            .subtitle {
                text-align: center;
                font-size: 11px;
                margin: 10px 0;
                line-height: 1.4;
            }
            .section-title {
                font-size: 14px;
                font-weight: bold;
                margin: 15px 0 10px 0;
            }
            .content {
                font-size: 10px;
                line-height: 1.6;
                margin: 5px 0;
            }
            .point {
                margin: 5px 0;
            }
            .seal-sign-area {
                display: flex;
                margin-top: 20px;
                gap: 30px;
            }
            .seal-box, .sign-box {
                width: 80px;
                height: 80px;
                border: 1px dashed #ccc;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 9px;
                color: #999;
            }
            .seal-box img, .sign-box img {
                max-width: 100%;
                max-height: 100%;
            }
            .digital-sig {
                font-size: 8px;
                margin-top: 20px;
                line-height: 1.4;
                width: 60%;
            }
            .qr-code {
                position: absolute;
                bottom: 20px;
                right: 20px;
                width: 60px;
                height: 60px;
            }
            .qr-code img {
                width: 100%;
                height: 100%;
            }
            .watermark {
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%) rotate(-45deg);
                font-size: 80px;
                color: rgba(200, 150, 150, 0.15);
                font-weight: bold;
                z-index: 0;
                pointer-events: none;
            }
            @media print {
                body {
                    margin: 0;
                    padding: 0;
                }
                .container {
                    border: none;
                    margin: 0;
                    padding: 20px;
                }
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="watermark">Certified</div>
            
            <div class="title">E-APOSTILLE</div>
            
            <div class="subtitle">
                (Convention de La Haye du 5 octobre 1961)
            </div>
            
            <div class="subtitle">
                (Also valid for the countries that are not in reciprocal arrangement with Bangladesh under the Apostille Convention of 1961, subject to proper legalisation)
            </div>
            
            <div class="section-title">Issuing Authority</div>
            
            <div class="content">
                <div class="point"><strong>1. Country:</strong> <strong>BANGLADESH</strong></div>
                <div class="point">The public document</div>
                <div class="point"><strong>2. has been signed by:</strong> <strong>' . htmlspecialchars($apostille['signed_by_sp']) . '</strong></div>
                <div class="point"><strong>3. acting in the capacity of:</strong> ' . htmlspecialchars($apostille['superintendent']) . '</div>
                <div class="point"><strong>4. bears the seal/stamp of:</strong> ' . htmlspecialchars($apostille['seal_stamp_district']) . '</div>
            </div>
            
            <div class="section-title">Certified</div>
            
            <div class="content">
                <div class="point"><strong>5.</strong> at Dhaka, Bangladesh</div>
                <div class="point"><strong>6.</strong> the <strong>' . date('d-M-Y', strtotime($apostille['ministry_signature_date'])) . '</strong></div>
                <div class="point"><strong>7.</strong> by <strong>' . htmlspecialchars($apostille['competent_by_ministry']) . '</strong></div>
                <div class="point"><strong>8.</strong> No ' . htmlspecialchars($apostille['certificate_number']) . '</div>
                <div class="point" style="margin-top: 10px;"><strong>9. Seal/stamp     10. Signature</strong></div>
            </div>
            
            <div class="seal-sign-area">
                <div class="seal-box">
                    ' . ((!empty($apostille['seal_stamp_image']) && file_exists('../' . htmlspecialchars($apostille['seal_stamp_image']))) ? '<img src="../' . htmlspecialchars($apostille['seal_stamp_image']) . '">' : 'SEAL') . '
                </div>
                <div class="sign-box">
                    ' . ((!empty($apostille['ministry_sign_image']) && file_exists('../' . htmlspecialchars($apostille['ministry_sign_image']))) ? '<img src="../' . htmlspecialchars($apostille['ministry_sign_image']) . '">' : 'SIGN') . '
                </div>
            </div>
            
            <div class="digital-sig">
                <strong>Digitally signed by</strong><br>
                ' . htmlspecialchars($apostille['ministry_name']) . '<br>
                Date: ' . date('Y-m-d', strtotime($apostille['ministry_signature_date'])) . '<br>
                Time: ' . date('H:i:s', strtotime($apostille['ministry_signature_date'])) . ' +06:00<br>
                Reason: Document verification<br>
                Location: Ministry of Foreign Affairs, Dhaka, BD
            </div>
            
            <div class="qr-code">
                <img src="https://api.qrserver.com/v1/create-qr-code/?data=' . urlencode($apostille['qrLink']) . '&size=60x60" alt="QR Code">
            </div>
        </div>
    </body>
    </html>';
    
    // HTML2PDF লাইব্রেরি ছাড়া সরাসরি ব্রাউজারে প্রিন্ট করার জন্য রিডাইরেক্ট করুন
    // অথবা একটি সাধারণ HTML ডাউনলোড করুন যা ইউজার প্রিন্ট করতে পারে
    
    header('Content-Type: text/html; charset=utf-8');
    header('Content-Disposition: attachment; filename="Apostille-' . htmlspecialchars($apostille['certificate_number']) . '.html"');
    echo $html;
    
    mysqli_close($link);
    exit;
}

// Regular HTML page view
$unique_id = $_GET['uniqueid'] ?? '';
$apostille = null;
$error = '';

if (!empty($unique_id)) {
    $sql = "SELECT a.*, u.name as user_name FROM apostille_log a 
            LEFT JOIN users u ON a.user = u.email 
            WHERE a.unique_id = ? AND a.status = 'active'";
    
    $stmt = mysqli_prepare($link, $sql);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $unique_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        
        if ($result && mysqli_num_rows($result) > 0) {
            $apostille = mysqli_fetch_assoc($result);
        } else {
            $error = 'E-Apostille not found or inactive.';
        }
        mysqli_stmt_close($stmt);
    } else {
        $error = 'Database error occurred.';
    }
} else {
    $error = 'Invalid verification link.';
}

if ($apostille) {
    date_default_timezone_set('Asia/Dhaka');
    $current_time = date('H:i:s');
    $ministry_signature_date_formatted = date('d-M-Y', strtotime($apostille['ministry_signature_date']));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>- Apostille</title>
    <link rel="icon" type="image/x-icon" href="../assets/images/logo2.png">
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600" rel="stylesheet" />
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Figtree', sans-serif;
            background: #ffffff;
            color: #333;
        }
        
        header {
            min-height: 100px;
            padding-top: 8px;
            background: white;
        }
        
        .container {
            max-width: 1200px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .text-xl { font-size: 20px; }
        .text-2xl { font-size: 24px; }
        .font-semibold { font-weight: 600; }
        .mx-4 { margin-left: 16px; margin-right: 16px; }
        .py-8 { padding-top: 32px; padding-bottom: 32px; }
        .p-3 { padding: 12px; }
        .mb-3 { margin-bottom: 12px; }
        .p-2 { padding: 8px; }
        .p-4 { padding: 16px; }
        .mb-4 { margin-bottom: 16px; }
        .mr-8 { margin-right: 32px; }
        .flex { display: flex; }
        .flex-col { flex-direction: column; }
        .items-center { align-items: center; }
        .justify-between { justify-content: space-between; }
        .justify-center { justify-content: center; }
        .justify-end { justify-content: flex-end; }
        .w-full { width: 100%; }
        .rounded-md { border-radius: 6px; }
        .border-2 { border: 2px solid #ddd; }
        .bg-white { background: white; }
        
        .pdf-display-container {
            width: 100%;
            height: 800px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f5f5f5;
            border-radius: 4px;
            position: relative;
            iframe {
                width: 100%;
                height: 100%;
                border: none;
            }
        }
        
        .loader {
            border: 3px solid #e0e0e0;
            border-top: 3px solid #808080;
            border-radius: 50%;
            width: 70px;
            height: 70px;
            animation: spin 0.3s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .download-btn {
            display: inline-flex;
            align-items: center;
            padding: 8px 16px;
            background: #1f2937;
            border: none;
            border-radius: 4px;
            font-weight: 600;
            font-size: 12px;
            color: white;
            text-transform: uppercase;
            cursor: pointer;
            transition: background 0.15s ease-in-out;
        }
        
        .download-btn:hover {
            background: #374151;
        }
        
        .download-btn svg {
            margin-right: 8px;
            width: 16px;
            height: 16px;
        }
        
        footer {
            width: 100%;
            background: #f3f3f9;
            border-top: 1px solid #dfdfe2;
            margin-top: auto;
        }
        
        .footer-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 16px;
            padding: 8px 24px;
        }
        
        .footer-left, .footer-right {
            display: flex;
            align-items: center;
        }
        
        .footer-left img {
            height: 48px;
            border-radius: 12px;
            margin-right: 16px;
        }
        
        .footer-right img {
            height: 40px;
        }
        
        .footer-text {
            font-size: 16px;
            margin: 0;
        }
        
        .error-message {
            background: #fee2e2;
            border: 1px solid #fca5a5;
            padding: 16px;
            border-radius: 4px;
            color: #991b1b;
            margin: 16px 0;
        }
        
        .certificate-section {
            margin-top: 32px;
            padding-top: 32px;
            border-top: 1px solid #e0e0e0;
        }
        
        .certificate-img {
            width: 100%;
            max-height: 600px;
            object-fit: contain;
            margin-bottom: 16px;
        }
        
        .cert-info-box {
            text-align: center;
            color: #6b21a8;
        }
        
        .cert-signature-img {
            height: 64px;
            margin: 12px 0;
        }
        
        .cert-date {
            font-size: 20px;
            font-weight: 600;
            margin: 12px 0;
        }
        
        .cert-name {
            font-weight: 500;
            margin: 4px 0;
        }
        
        @media (max-width: 768px) {
            .text-2xl { font-size: 18px; }
            .footer-container {
                flex-direction: column;
                text-align: center;
            }
            .footer-left, .footer-right {
                justify-content: center;
                width: 100%;
            }
        }
    </style>
</head>
<body class="bg-white">
    <div id="app">
        <div class="bg-white flex flex-col justify-between" style="min-height: 100vh;">
            <header>
                <div class="flex justify-between mx-4">
                    <img src="../assets/images/logo3.png" alt="Logo" width="200">
                </div>
            </header>
            
            <div>
                <div class="container mx-auto">
                    <div class="py-8">
                        <div class="w-full">
                            <div class="text-xl md:text-2xl p-3 mb-3">
                                <p class="font-semibold">অ্যাপোস্টিল</p>
                            </div>
                            
                            <?php if (!empty($error)): ?>
                                <div class="error-message">
                                    <strong>✗ ত্রুটি:</strong> <?php echo htmlspecialchars($error); ?>
                                </div>
                            <?php else: ?>
                                <div class="flex items-center font-sans">
                                    <div class="p-2 rounded-md border-2">
                                        <div style="width: 390px; margin: 0 auto;">
                                            <div class="mb-4 flex justify-center">
                                                <div class="pdf-display-container">
                                                    <div class="loader"></div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="flex justify-end mr-8">
                                            <a href="?uniqueid=<?php echo htmlspecialchars($unique_id); ?>&action=generate_pdf" class="download-btn">
                                                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M216 0h80c13.3 0 24 10.7 24 24v168h87.7c17.8 0 26.7 21.5 14.1 34.1L269.7 378.3c-7.5 7.5-19.8 7.5-27.3 0L90.1 226.1c-12.6-12.6-3.7-34.1 14.1-34.1H192V24c0-13.3 10.7-24 24-24zm296 376v112c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V376c0-13.3 10.7-24 24-24h146.7l49 49c20.1 20.1 52.5 20.1 72.6 0l49-49H488c13.3 0 24 10.7 24 24zm-124 88c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20zm64 0c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20z"></path>
                                                </svg>
                                                অ্যাপোস্টিল ডাউনলোড
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <?php if ($apostille): ?>
                    <div class="certificate-section">
                        <div class="w-full">
                            <div class="text-xl md:text-2xl p-3 my-5">
                                <p class="font-semibold">সনদপত্র/নম্বরপত্র/একাডেমিক ট্রান্সক্রিপ্ট/ডকুমেন্টস</p>
                            </div>
                            
                            <div class="w-full">
                                <div class="p-4 bg-white border-2 rounded-md mb-3">
                                    <?php if (!empty($apostille['front_part_scan_copy'])): ?>
                                        <img src="https://pcc.police.gov.bd.ords.pw/<?php echo htmlspecialchars($apostille['front_part_scan_copy']); ?>" alt="Certificate" class="certificate-img">
                                    <?php endif; ?>
                                    
                                    <div class="flex justify-center px-6 py-4">
                                        <div class="cert-info-box">
                                            <h1 style="font-weight: 700; font-size: 20px; margin-top: 12px;">Attested</h1>
                                            
                                            <div class="flex items-center justify-center">
                                                <?php if (!empty($apostille['dsb_sign_image'])): ?>
                                                    <img src="https://pcc.police.gov.bd.ords.pw/<?php echo htmlspecialchars($apostille['dsb_sign_image']); ?>" alt="Signature" class="cert-signature-img">
                                                <?php endif; ?>
                                            </div>
                                            
                                            <p class="cert-date"><?php echo $ministry_signature_date_formatted; ?></p>
                                            
                                            <p class="cert-name"><?php echo htmlspecialchars($apostille['signed_by_sp']); ?></p>
                                            <p class="cert-name"><?php echo htmlspecialchars($apostille['superintendent']); ?></p>
                                            <p class="cert-name"><?php echo htmlspecialchars($apostille['seal_stamp_district']); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <footer class="w-full bg-[#f3f3f9] border-t border-[#dfdfe2]">
        <div class="footer-container">
            <div class="footer-left">
                <img src="../assets/images/logo4.png" alt="Logo">
                <div>
                    <p class="footer-text">কপিরাইট © ২০২৫ সর্বস্বত্ব সংরক্ষিত</p>
                    <p class="footer-text">গণপ্রজাতন্ত্রী বাংলাদেশ সরকার</p>
                </div>
            </div>
            <div class="footer-right">
                <span class="footer-text" style="margin-right: 12px;">পরিকল্পনা বাস্তবায়নে</span>
                <img src="../assets/images/logo5.png" alt="Implementation Partner">
            </div>
        </div>
    </footer>
    
    <script>
        window.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                document.querySelector('.loader').style.display = 'none';
            }, 300);
        });
    </script>
</body>
</html>