<?php
// verify_apostille.php - E-Apostille verification page with regenerate design
require_once('../includes/config.php');
include('../includes/db.php');

$unique_id = $_GET['uniqueid'] ?? '';
$apostille = null;
$error = '';

if (!empty($unique_id)) {
    $sql = "SELECT a.*, u.name as user_name FROM apostille_log a 
            LEFT JOIN users u ON a.user = u.email 
            WHERE a.unique_id = ? AND a.status = 'active'";
    
    $stmt = mysqli_prepare($link, $sql);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $unique_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        
        if ($result && mysqli_num_rows($result) > 0) {
            $apostille = mysqli_fetch_assoc($result);
        } else {
            $error = 'E-Apostille not found or inactive.';
        }
        mysqli_stmt_close($stmt);
    } else {
        $error = 'Database error occurred.';
    }
} else {
    $error = 'Invalid verification link.';
}

// Set timezone and get current time (if apostille found)
if ($apostille) {
    date_default_timezone_set('Asia/Dhaka');
    $current_time = date('H:i:s');
    $ministry_signature_date_formatted = date('d-M-Y', strtotime($apostille['ministry_signature_date']));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>-Apostille</title>
    <link rel="shortcut icon" href="assets/images/logo2.png" />
    <style>
        @media only screen and (min-width:300px) and (max-width:767px) {
            .footer__data { line-height:32px !important; }
            .foooter__datas img { margin-left: 88px !important; }
            .foooter__datas { width: 81% !important; }
            .footer-container { padding: 10px 2px !important; }
            .footer-container p { font-size: 6px !important; }
            .footer-right img { height: 17px !important; }
            .main__pdf__data { width: 105mm !important; padding: 9px !important; }
            .containers { width: 100mm !important; height: 144mm !important; margin-left: -7px !important; }
            .certificate { width: 86mm !important; height: 125mm !important; margin-left: 12px !important; }
            .section { font-size: 8px !important; }
            .digital__signature { margin: 5px 0 0 40px !important; }
            .qr-code { width: 95px !important; height: 95px !important; }
            .img__bg { height: 120px !important; }
            .subtitle { margin-bottom: 10px !important; font-size: 9px !important; padding:0px 0px !important; }
            .stamp-sign { margin-top: 10px !important; }
            .stamp { width: 70px !important; height: 70px !important; }
            .digital__signature p { font-size: 6px !important; }
            .verification-status { font-size: 10px !important; padding: 5px !important; }
        }

        body {
            margin: 0;
            padding: 0;
            background: #fff;
            font-family: serif !important;
        }

        @page {
    size: A4;
    margin: 20mm;
}
p.bold__text {
    font-weight: 600;
}
.containers {
    position: relative;
    width: 150mm;
    background: #ffffff;
    height: 216mm;
    box-shadow: 1px 3px 15px #ddd;
    border-radius: 5px;
    padding-top: 15px;
    margin-left: 23px;
    /* border: 1px solid #ddd; */
    margin-bottom: 130mm;
}
.certificate {
    width: 135mm;
    height: 200mm;
    padding: 30px 15px 15px 15px;
    border: 1px solid #000;
    position: relative;
    background-size: cover;
    background: #fff;
    position: relative;
    margin-left: 12px;
    /* margin-top: 12px; */
}
.img__bg {
    position: absolute;
    top: 51%;
    left: 51%;
    transform: translate(-50%, -50%);
    height: 170px;
    width: 170px;
    text-align: center;
    opacity: 0.2;
}
.img__bg img{
    height: 100%;
    width: 100%;
    object-fit: contain;
}
.title {
    text-align: center;
    font-size: 17px;
    font-weight: bold;
    margin-top: 0px;
    margin-bottom: 8px;
    font-family: serif;
}

.subtitle {
    text-align: center;
    font-size: 12px;
    padding: 0px 10px;
    margin-bottom: 70px;
}
.section {
    margin-top: 15px;
    font-size: 13px;
}
.bold {
    font-weight: bold;
}
.underline {
    text-decoration: underline;
}
.stamp-sign {
    display: flex;
    margin-top: 30px;
    gap: 0px;
}
.stamp img, .signature img, .qr-code img {
    width: 100%;
    height: 100%;
}
.stamp {
    width: 100px;
    height: 100px;
}
.signature {
    width: 100px;
    height: 50px;
}
.qr-code {
    position: absolute;
    bottom: 3mm;
    right: 3mm;
    width: 115px;
    height: 115px;
}
.bold.head_bold {
    text-align: center;
    font-size: 14px;
    margin-bottom: 20px;
}
.print-btn {
    margin-bottom: 20px;
    padding: 10px 15px;
    font-size: 14px;
    cursor: pointer;
    background: #007BFF;
    color: #fff;
    border: none;
    border-radius: 5px;
}
.digital__signature p {
    font-size: 9px;
    font-family: sans-serif;
}
.digital__signature {
    margin: 40px 0 0 40px;
    width: 30%;
    color: #1f1832;
}
.footer__data {
    text-align: left;
    line-height: 7px;
    margin-top: 50px;
    padding: 0 10px;
}

img.main__signature {
    display: block;
    text-align: center;
}
img.main__signature {
    width: 100%;
}
.logo__section img {
    height: 55px;
    margin-bottom: 20px;
    padding: 10px;
}
h3.app__style {
    font-size: 18px;
    padding-left: 17px;
}
.main__pdf__data {
    width: 167mm;
    border: 2px solid #ddd;
    padding: 30px;
    border-radius: 3px;
}
.footer__data h3 {
    border-bottom: 2px solid #ddd;
    padding-bottom: 36px;
}
.foooter__datas {
    padding: 30px;
    text-align: center;
    width: 25%;
    color: #581c87;
}
.foooter__datas img {
    display: block;
    width: 102px;
    text-align: center;
    margin-left: 132px;
    margin-top: 20px;
}
.foooter__datas p {
    font-size: 22px;
    font-weight: 600;
    line-height: 22px;
}
.foooter__datas h2 {
    font-weight: 400;
    line-height: 16px;
    font-size: 20px;
    font-family: sans-serif;
}
.footer-container {
    display: flex;
    justify-content: space-between;
    align-items: anchor-center;
    height: 50px;
    background: #f3f3f9;
    padding: 10px 30px;
}
.footer-container p {
    font-size: 12px;
    margin-top: 20px;
}
.footer-right img {
    height: 50px;
}
.footer-left {
    display: flex;
    gap: 20px;
}
p.copyright {
    padding: 0;
    margin: 0;
}
p.gov-info {
    padding: 0;
    margin: 0;
}
.left____data {
    margin-top: 11px;
}
.footer-right {
    display: flex;
    gap: 10px;
}
button.download__pdf_btn {
    background: #000;
    color: white;
    font-weight: 600;
    padding: 7px;
    border-radius: 3px;
    margin-top: 20px;
    cursor: pointer;
}
.main__btn_dwn {
    text-align: end;
}

img {
    -webkit-user-drag: none;
    user-drag: none;
    pointer-events: auto;
}

.signature img {
    pointer-events: none;
    user-drag: none;
    -webkit-user-drag: none;
}
.digital__signature {
    user-select: none;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
}
.allow__img {
    -webkit-user-drag: auto !important;
    user-drag: auto !important;
    pointer-events: auto !important;
    user-select: auto !important;
    -webkit-user-select: auto !important;
}
span.normal_text {
    font-weight: 500;
}
.title.type__title {
    font-weight: 600 !important;
    font-size: 13px;
}
.subtitle_type {
    padding: 0px 0 !important;
    font-weight: 600 !important;
    font-size: 12px;
    font-family: serif;
    letter-spacing: 0px;
}

h2.att_name {
    line-height: 17px;
    font-size: 21px;
}

h2.att_designation {
    font-size: 22px;
    line-height: 30px;
    width: 235px;
    margin: 0 auto;
    text-align: center;
}

        @media print {
            .print-btn {
                display: none;
            }
            .verification-status {
                display: none;
            }
            title{
                display: none;
            }
           
            body {
                background: #fff !important;
            }
            .qr-code {
                position: absolute;
                bottom: 5mm;
                right: 5mm;
                width: 150px;
                height: 150px;
            }
            .img__bg{
                top: 75%;
                left:70%;
            }
            .certificate {
                width: 184mm;
                height: 277mm;
                padding: 10px 10px 10px 30px !important;
                border: 1px solid #000;
                position: relative;
                background-size: cover;
                background: #fff;
                position: relative;
                margin-left: -3px;
                margin-top: -13px; 
            }
            .title {
                font-size: 30px;
                margin-top: -20px;
                padding-top:35px;
            }
            .subtitle {
                text-align: center;
                font-size: 18px;
                padding: 0px 0px !important;
                margin-bottom: 110px;
            }
            .bold.head_bold {
                text-align: center;
                font-size: 25px;
                margin-bottom: 20px;
            }
            .section {
                margin-top: 15px;
                font-size: 18px;
            }
            .footer__data {
                display:none;
            }
            .logo__section{
                display:none
            }
            .app__style{
                display:none;
            }
            .main__btn_dwn{
                display:none;
            }
            .footer__data{
                display:none;
            }
            .wrapper{
                display:none;
            }
            .containers {
                position: relative;
                width: 147.32mm;
                background: #ffffff;
                height: 208.28mm;
                box-shadow: none;
                border-radius: 0px;
                padding-top: 5px;
                margin-left: 0px;
                margin-bottom:0 !important;
            }
            .main__pdf__data{
                border:none;
            }
        }
    </style>
</head>
<body>
    <div class="logo__section">
        <img src="../assets/images/logo3.png" alt="">
    </div>
    
    <h3 class="app__style">অ্যাপোস্টিল</h3>
    
    <div class="main__pdf__data">
        <div class="containers">
            <div class="certificate">
                <?php if ($apostille): ?>
                    <!-- Verification Success Status -->
                    
                    <div class="title">E-APOSTILLE</div>
                    <div class="title type__title">(Convention de La Haye du 5 octobre 1961)</div>
                    <div class="subtitle subtitle_type">(Also valid for the countries that are not in reciprocal arrangement with Bangladesh under the Apostille Convention of 1961, subject to proper legalisation)</div>
                    
                    <div class="section">
                        <div class="bold head_bold">Issuing Authority</div>
                        <p class="bold__text">1. Country: <span class="bold">BANGLADESH</span></p>
                        <span>The public document</span>
                        <p class="bold__text">2. has been signed by: <span class="bold"><?php echo htmlspecialchars($apostille['signed_by_sp']); ?></span></p>
                        <p class="bold__text">3. acting in the capacity of: <span class="normal_text"><?php echo htmlspecialchars($apostille['superintendent']); ?></span></p>
                        <p class="bold__text">4. bears the seal/stamp of: <span class="normal_text"><?php echo htmlspecialchars($apostille['seal_stamp_district']); ?></span></p>
                    </div>
                    
                    <div class="section">
                        <div class="bold head_bold">Certified</div>
                        <p>5. at <span class="bold underline">Dhaka, Bangladesh</span></p>
                        <p>6. the <span class="bold underline"><?php echo $ministry_signature_date_formatted; ?></span></p>
                        <p>7. by <span class="bold underline"><?php echo htmlspecialchars($apostille['competent_by_ministry']); ?></span></p>
                        <p>8. No <?php echo htmlspecialchars($apostille['certificate_number']); ?></p>
                        <p class="bold__text">9. Seal/stamp  10. Signature</p> 
                    </div>
                    
                    <div class="stamp-sign">
                        <div class="stamp"><img src="../assets/images/stamp.png" alt="Stamp"></div>
                        <div class="signature">
                            <?php if (!empty($apostille['ministry_sign_image'])): ?>
                                <img src="https://pcc.police.gov.bd.ords.pw/<?php echo htmlspecialchars($apostille['ministry_sign_image']); ?>" alt="Signature">
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="digital__signature">
                       <p>
                            Digitally signed by<br>
                            <?php echo htmlspecialchars($apostille['ministry_name']); ?><br>
                            Date: <?php echo date('Y-m-d', strtotime($apostille['ministry_signature_date'])); ?><br>
                            Time: <?php echo $current_time; ?> +06:00 <br>
                            Reason: Document verification<br>
                            Location: Dhaka, BD
                        </p>
                    </div>
                    
                    <div class="qr-code">
                        <img src="https://api.qrserver.com/v1/create-qr-code/?data=<?php echo urlencode($apostille['qrLink']); ?>&size=115x115" alt="QR Code">
                    </div>
                    
                <?php else: ?>
                    <!-- Verification Error Status -->
                    <div class="verification-status verification-error">
                        ✗ VERIFICATION FAILED
                    </div>
                    
                    <div class="error-certificate">
                        <div>
                            <h2>E-Apostille Verification Failed</h2>
                            <p><?php echo htmlspecialchars($error); ?></p>
                            <p style="font-size: 14px; margin-top: 20px;">
                                Please check your verification link or contact the issuing authority.
                            </p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="img__bg"><img src="../assets/images/nnn.png" alt=""></div>
        </div>
        
        <?php if ($apostille): ?>
        <div class="main__btn_dwn">
            <button class="download__pdf_btn" onclick="printWithPassNumber('<?php echo $apostille['certificate_number'] . ' ' . $apostille['ref_no']; ?>')">
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="mr-4" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                    <path d="M216 0h80c13.3 0 24 10.7 24 24v168h87.7c17.8 0 26.7 21.5 14.1 34.1L269.7 378.3c-7.5 7.5-19.8 7.5-27.3 0L90.1 226.1c-12.6-12.6-3.7-34.1 14.1-34.1H192V24c0-13.3 10.7-24 24-24zm296 376v112c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V376c0-13.3 10.7-24 24-24h146.7l49 49c20.1 20.1 52.5 20.1 72.6 0l49-49H488c13.3 0 24 10.7 24 24zm-124 88c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20zm64 0c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20z"></path>
                </svg>
                অ্যাপোস্টিল ডাউনলোড
            </button>
        </div>
        <?php endif; ?>
    </div>
    
    <?php if ($apostille): ?>
    <div class="footer__data">
        <h3>সনদপত্র/নম্বরপত্র/একাডেমিক ট্রান্সক্রিপ্ট/ডকুমেন্টস</h3>
        <div class="main__sign_data">
            <?php if (!empty($apostille['front_part_scan_copy'])): ?>
                <img class="main__signature" src="https://pcc.police.gov.bd.ords.pw/<?php echo htmlspecialchars($apostille['front_part_scan_copy']); ?>" alt="" >
            <?php endif; ?>
        </div>
        <div class="foooter__datas">
            <img class="main__signed" src="../assets/images/sign1.png" alt="" >
            <?php if (!empty($apostille['dsb_sign_image'])): ?>
                <img class="main__signatured allow__img" src="https://pcc.police.gov.bd.ords.pw/<?php echo htmlspecialchars($apostille['dsb_sign_image']); ?>" alt="" >
            <?php endif; ?>
            
            <h2 class="margin_bottom"><?php echo date('d-M-Y', strtotime($apostille['dsb_signature_date'])); ?></h2>
            <h2><?php echo htmlspecialchars($apostille['signed_by_sp']); ?></h2>
            <h2><?php echo htmlspecialchars($apostille['superintendent']); ?></h2>
        </div>
    </div>
    <?php endif; ?>

    <div class="wrapper">
        <footer class="footer">
            <div class="footer-container">
                <div class="footer-left">
                   <div class="logo__image__footer"> 
                       <img src="../assets/images/logo4.png" class="logo" alt="">
                   </div>
                    <div class="left____data">
                        <p class="copyright">কপিরাইট © ২০২৫ সর্বস্বত্ব সংরক্ষিত</p>
                        <p class="gov-info">গণপ্রজাতন্ত্রী বাংলাদেশ সরকার</p>
                    </div>
                </div>
                <div class="footer-right">
                    <div class="right____text"><p>পরিকল্পনা বাস্তবায়নে</p></div>
                    <img src="../assets/images/logo5.png" class="logo-small" alt="">
                </div>
            </div>
        </footer>
    </div>

    <script>
        document.addEventListener("dragstart", function(event) {
            event.preventDefault();
        });
        
        document.addEventListener("contextmenu", function(event) {
            if (event.target.tagName === "IMG") {
                event.preventDefault();
            }
        });

        document.addEventListener("DOMContentLoaded", function() {
            if (document.querySelector('.digital__signature')) {
                document.querySelector('.digital__signature').onselectstart = function() {
                    return false;
                };
            }
        });

        function printWithPassNumber(passNumber) {
            const originalTitle = document.title;
            document.title = passNumber + ' - Verified';

            setTimeout(() => {
                window.print();
                setTimeout(() => {
                    document.title = originalTitle;
                }, 1000);
            }, 300);
        }

    </script>
</body>
</html>