<?php
// verify_apostille.php - E-Apostille verification page with regenerate design
require_once('../includes/config.php');
include('../includes/db.php');

$unique_id = $_GET['uniqueid'] ?? '';
$apostille = null;
$error = '';

if (!empty($unique_id)) {
    $sql = "SELECT a.*, u.name as user_name FROM apostille_log a 
            LEFT JOIN users u ON a.user = u.email 
            WHERE a.unique_id = ? AND a.status = 'active'";
    
    $stmt = mysqli_prepare($link, $sql);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $unique_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        
        if ($result && mysqli_num_rows($result) > 0) {
            $apostille = mysqli_fetch_assoc($result);
        } else {
            $error = 'E-Apostille not found or inactive.';
        }
        mysqli_stmt_close($stmt);
    } else {
        $error = 'Database error occurred.';
    }
} else {
    $error = 'Invalid verification link.';
}

// Set timezone and get current time (if apostille found)
if ($apostille) {
    date_default_timezone_set('Asia/Dhaka');
    $current_time = date('H:i:s');
    $ministry_signature_date_formatted = date('d-M-Y', strtotime($apostille['ministry_signature_date']));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>E-Apostille</title>
    <link rel="shortcut icon" href="../assets/images/logo2.png" />
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f8f8;
        }

        header {
            background-color: #fff;
            padding: 10px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        header img {
            height: 60px;
        }

        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 0 15px;
        }

        h1.title {
            font-size: 28px;
            font-weight: 600;
            text-align: center;
            margin-bottom: 20px;
            color: #4B0082;
        }

        .pdf-section {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            position: relative;
        }

        #loader {
            border: 4px solid #e0e0e0;
            border-top: 4px solid #4B0082;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 0.6s linear infinite;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        @keyframes spin {
            0% { transform: rotate(0deg);}
            100% { transform: rotate(360deg);}
        }

        #pdf-canvas {
            display: none;
            width: 100%;
            height: auto;
            border: 1px solid #ddd;
        }

        .download-btn {
            display: inline-flex;
            align-items: center;
            padding: 10px 15px;
            margin-top: 15px;
            background-color: #4B0082;
            color: #fff;
            font-weight: 600;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .download-btn svg {
            margin-right: 8px;
        }

        .document-info {
            margin-top: 20px;
            background: #fafafa;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid #ddd;
        }

        .document-info h2 {
            margin-bottom: 10px;
            color: #333;
        }

        .document-info p {
            margin-bottom: 6px;
            font-size: 14px;
        }

        footer {
            margin-top: 40px;
            background-color: #fff;
            padding: 15px 20px;
            text-align: center;
            color: #555;
            font-size: 14px;
            border-top: 1px solid #ddd;
        }

        .error-message {
            text-align: center;
            background: #ffe5e5;
            color: #900;
            padding: 20px;
            border-radius: 10px;
            margin-top: 30px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <header>
        <img src="../assets/images/logo3.png" alt="Logo">
        <h1 class="title">E-Apostille Verification</h1>
    </header>

    <div class="container">
        <?php if ($apostille): ?>
        <div class="pdf-section">
            <div id="loader"></div>
            <canvas id="pdf-canvas"></canvas>
            <button class="download-btn" id="download-btn">
                <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                    <path d="M216 0h80c13.3 0 24 10.7 24 24v168h87.7c17.8 0 26.7 21.5 14.1 34.1L269.7 378.3c-7.5 7.5-19.8 7.5-27.3 0L90.1 226.1c-12.6-12.6-3.7-34.1 14.1-34.1H192V24c0-13.3 10.7-24 24-24zm296 376v112c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V376c0-13.3 10.7-24 24-24h146.7l49 49c20.1 20.1 52.5 20.1 72.6 0l49-49H488c13.3 0 24 10.7 24 24zm-124 88c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20zm64 0c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20z"></path>
                </svg>
                Download Apostille
            </button>
        </div>

        <div class="document-info">
            <h2>Document Details</h2>
            <p><strong>Certificate No:</strong> <?php echo htmlspecialchars($apostille['certificate_number']); ?></p>
            <p><strong>Signed By:</strong> <?php echo htmlspecialchars($apostille['signed_by_sp']); ?></p>
            <p><strong>Superintendent:</strong> <?php echo htmlspecialchars($apostille['superintendent']); ?></p>
            <p><strong>Ministry Signature Date:</strong> <?php echo $ministry_signature_date_formatted; ?></p>
        </div>

        <?php else: ?>
            <div class="error-message">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
    </div>

    <footer>
        কপিরাইট © ২০২৫ সর্বস্বত্ব সংরক্ষিত | গণপ্রজাতন্ত্রী বাংলাদেশ সরকার
    </footer>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.313/pdf.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            <?php if ($apostille): ?>
                const pdfUrl = 'public/files/upload.pdf'; // আপনার PDF পাথ
                const loader = document.getElementById('loader');
                const canvas = document.getElementById('pdf-canvas');
                const ctx = canvas.getContext('2d');

                pdfjsLib.getDocument(pdfUrl).promise.then(pdf => pdf.getPage(1))
                    .then(page => {
                        const viewport = page.getViewport({scale: 1});
                        canvas.width = viewport.width;
                        canvas.height = viewport.height;

                        page.render({canvasContext: ctx, viewport: viewport}).promise.then(() => {
                            loader.style.display = 'none';
                            canvas.style.display = 'block';
                        });
                    })
                    .catch(err => {
                        console.error('PDF rendering error:', err);
                        loader.style.display = 'none';
                    });

                const downloadBtn = document.getElementById('download-btn');
                downloadBtn.addEventListener('click', () => {
                    const a = document.createElement('a');
                    a.href = pdfUrl;
                    a.download = 'Apostille-<?php echo $apostille["certificate_number"]; ?>.pdf';
                    document.body.appendChild(a);
                    a.click();
                    document.body.removeChild(a);
                });
            <?php endif; ?>
        });
    </script>
</body>
</html>