<?php  
header('Content-Type: text/html; charset=utf-8');
//  index.php - E-Apostille verification page with regenerate design  
require_once('../includes/config.php');  
include('../includes/db.php');  
  
$certificate_number = $_GET['certificate_number'] ?? '';  
$apostille = null;  
$error = '';  
  
if (!empty($certificate_number)) {  
    $sql = "SELECT a.*, u.name as user_name FROM apostille_log a   
            LEFT JOIN users u ON a.user = u.email   
            WHERE a.certificate_number = ? AND a.status = 'active'";  
      
    $stmt = mysqli_prepare($link, $sql);  
    if ($stmt) {  
        mysqli_stmt_bind_param($stmt, "s", $certificate_number);  
        mysqli_stmt_execute($stmt);  
        $result = mysqli_stmt_get_result($stmt);  
          
        if ($result && mysqli_num_rows($result) > 0) {  
            $apostille = mysqli_fetch_assoc($result);  
        } else {  
            $error = 'E-Apostille not found or inactive.';  
        }  
        mysqli_stmt_close($stmt);  
    } else {  
        $error = 'Database error occurred.';  
    }  
} else {  
    $error = 'Invalid verification link.';  
}  
  
// Set timezone and get current time (if apostille found)  
if ($apostille) {  
    date_default_timezone_set('Asia/Dhaka');  
    $current_time = date('H:i:s');  
    $ministry_signature_date_formatted = date('d-M-Y', strtotime($apostille['ministry_signature_date']));
    //svg date time by public it
    $svg_date_string = "Date: " . date('Y-m-d', strtotime($apostille['ministry_signature_date']));
    $svg_time_string = "Time:" . $current_time . " +06:00";  
}  

// Handle the SVG content replacement (only if apostille data found)  
$svgContent = '';
if ($apostille) {  
    $svgFile = 'Apostille.svg';  // ডিফল্ট SVG ফাইল

    // ✅ যদি কোন টিক মার্ক দেয় তাহলে সেই অনুযায়ী SVG লোড হবে
    if (!empty($apostille['ministry1']) && $apostille['ministry1'] === 'Yes') {
        $svgFile = 'Ministry1.svg';
    } elseif (!empty($apostille['ministry2']) && $apostille['ministry2'] === 'Yes') {
        $svgFile = 'Ministry2.svg';
    } elseif (!empty($apostille['ministry3']) && $apostille['ministry3'] === 'Yes') {
        $svgFile = 'Ministry3.svg';
    } elseif (!empty($apostille['ministry4']) && $apostille['ministry4'] === 'Yes') {
        $svgFile = 'Ministry4.svg';
    }  
  
    if (file_exists($svgFile)) {  
        $svgContent = file_get_contents($svgFile);  
        $svgContent = mb_convert_encoding($svgContent, 'HTML-ENTITIES', 'UTF-8');

        if (!empty($apostille['ministry_sign_image'])) {
            $signUrl = 'https://pcc.police.gov.bd.ords.pw/' . $apostille['ministry_sign_image'];
            $svgContent = str_replace('{ministry_sign_image}', $signUrl, $svgContent);
        }
        
        
        // --- QR Code URL তৈরি এবং রিপ্লেস করা ---
        if (!empty($apostille['qrLink'])) {
            // আপনার আগের HTML কোড থেকে QR Code জেনারেটর URL ব্যবহার করে
            $qrCodeUrl = 'https://api.qrserver.com/v1/create-qr-code/?data=' . urlencode($apostille['qrLink']) . '&size=115x115';
            $svgContent = str_replace('{qrcode}', $qrCodeUrl, $svgContent);
        } else {
            // QR Link না থাকলে প্লেসহোল্ডার ফাঁকা রাখুন
            $svgContent = str_replace('{qrcode}', '', $svgContent); 
        }
        // --- QR Code রিপ্লেসমেন্ট শেষ ---
        
        
        // Replace placeholders with database data safely  
        $svgContent = str_replace('{signed_by_sp}', $apostille['signed_by_sp'] ?? '', $svgContent);  
        $svgContent = str_replace('{superintendent}', htmlspecialchars($apostille['superintendent'] ?? ''), $svgContent);  
        $svgContent = str_replace('{seal_stamp_district}', htmlspecialchars($apostille['seal_stamp_district'] ?? ''), $svgContent);  
        $svgContent = str_replace('{certificate_number}', htmlspecialchars($apostille['certificate_number'] ?? ''), $svgContent);  
        $svgContent = str_replace('{competent_by_ministry}', htmlspecialchars($apostille['competent_by_ministry'] ?? ''), $svgContent);
        $svgContent = str_replace('{ministry_name}', htmlspecialchars($apostille['ministry_name'] ?? ''), $svgContent);
        $svgContent = str_replace('{svg_date}', htmlspecialchars($svg_date_string ?? ''), $svgContent);
        $svgContent = str_replace('{svg_time}', htmlspecialchars($svg_time_string ?? ''), $svgContent);
        $svgContent = str_replace('{ministry_signature_date_formatted}',   
            $ministry_signature_date_formatted ?? '',   
            $svgContent  
        );  
  
    }  
} 
?>  
<!DOCTYPE html>  
<html lang="en">  
<head>  
    <meta charset="UTF-8">  
    <meta name="viewport" content="width=device-width, initial-scale=1.0">  
    <title>E-Apostille</title>  
    <link rel="shortcut icon" href="../assets/images/logo2.png" />  
    <style>  
        @media only screen and (min-width:300px) and (max-width:767px) {  
            .footer__data { line-height:32px !important; }  
            .foooter__datas img { margin-left: 88px !important; }  
            .foooter__datas { width: 81% !important; }  
            .footer-container { padding: 10px 2px !important; }  
            .footer-container p { font-size: 6px !important; }  
            .footer-right img { height: 17px !important; }  
            .main__pdf__data { width: 105mm !important; padding: 9px !important; }  
            .containers { width: 100mm !important; height: 244mm !important; margin-left: -7px !important; }  
            .certificate { width: 86mm !important; height: 125mm !important; margin-left: 12px !important; }  
            .section { font-size: 8px !important; }  
            .digital__signature { margin: 5px 0 0 40px !important; }  
            .digital__signature p { font-size: 6px !important; }  
            .verification-status { font-size: 10px !important; padding: 5px !important; }  
        }  

        body {  
            margin: 0;  
            padding: 0;  
            background: #fff;  
            font-family: serif !important;  
        }  

        @page {  
            size: A4;  
            margin: 20mm;  
        }

        /* --- লোডার CSS শুরু --- */
        
        .containers {
            position: relative; /* লোডারকে এর সাপেক্ষে absolute করবে */
            width: 150mm;
            height: 216mm;
            background: #ffffff;
            box-shadow: 1px 3px 15px #ddd;
            border-radius: 5px;
            padding-top: 15px;
            margin-left: 23px;
            overflow: hidden;
        }

        /* লোডার ওভারলে: .containers এরিয়াকে ঢেকে দেবে */
        .loader-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: #ffffff; 
            display: flex; 
            justify-content: center;
            align-items: center;
            z-index: 1000; 
        }

        /* Loader Spinner - আপনার দেওয়া মান অনুযায়ী */
        .loader {
            border: 1px solid #e0e0e0;
            border-top: 2px solid #808080;
            border-radius: 50%;
            width: 70px;
            height: 70px;
            animation: spin .3s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        /* --- লোডার CSS শেষ --- */


        /* SVG কে certificate এর পিছনে রাখা */
        .certificate {
            position: relative;
            width: 135mm;
            height: 200mm;
            padding: 30px 15px 15px 15px;

            background: #fff;
            margin-left: 12px;
            overflow: hidden;
        }

        /* SVG background হিসেবে certificate এর ভিতরে */
        .certificate::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
            opacity: 0.08;
            pointer-events: none;
            z-index: 0;
        }

        /* SVG container */
        .svg-watermark {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 1;
            pointer-events: none;
            z-index: 0;
            overflow: hidden;
        }

        .svg-watermark svg {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        

        /* সকল content z-index 1 এ থাকবে */
        .section {
            position: relative;
            z-index: 1;
            margin-top: 15px;
            font-size: 13px;
        }

        .underline {
            text-decoration: underline;
        }

        .signature img {
            width: 100%;
            height: 100%;
        }

        .signature {
            width: 100px;
            height: 50px;
        }

        .qr-code {
            position: absolute;
            bottom: 3mm;
            right: 3mm;
            width: 115px;
            height: 115px;
            z-index: 2;
        }

        .print-btn {
            margin-bottom: 20px;
            padding: 10px 15px;
            font-size: 14px;
            cursor: pointer;
            background: #007BFF;
            color: #fff;
            border: none;
            border-radius: 5px;
        }


        .footer__data {
            text-align: left;
            line-height: 7px;
            margin-top: 50px;
            padding: 0 10px;
        }

        img.main__signature {
            display: block;
            text-align: center;
        }

        img.main__signature {
            width: 100%;
        }

        .logo__section img {
            height: 55px;
            margin-bottom: 20px;
            padding: 10px;
        }

        h3.app__style {
            font-size: 18px;
            padding-left: 17px;
        }

        .main__pdf__data {
            width: 167mm;
            border: 2px solid #ddd;
            padding: 30px;
            border-radius: 3px;
        }

        .scancopyv1 {
            padding: 30px;
            border-radius: 3px;
        }

        .footer__data h3 {
            border-bottom: 2px solid #ddd;
            padding-bottom: 36px;
        }

        .foooter__datas {
            padding: 30px;
            text-align: center;
            width: 25%;
            color: #581c87;
        }

        .foooter__datas img {
            display: block;
            width: 102px;
            text-align: center;
            margin-left: 132px;
            margin-top: 20px;
        }

        .foooter__datas p {
            font-size: 22px;
            font-weight: 600;
            line-height: 22px;
        }

        .foooter__datas h2 {
            font-weight: 400;
            line-height: 16px;
            font-size: 20px;
            font-family: sans-serif;
        }

        .footer-container {
            display: flex;
            justify-content: space-between;
            align-items: anchor-center;
            height: 50px;
            background: #f3f3f9;
            padding: 10px 30px;
        }

        .footer-container p {
            font-size: 12px;
            margin-top: 20px;
        }

        .footer-right img {
            height: 50px;
        }

        .footer-left {
            display: flex;
            gap: 20px;
        }

        p.copyright {
            padding: 0;
            margin: 0;
        }

        p.gov-info {
            padding: 0;
            margin: 0;
        }

        .left____data {
            margin-top: 11px;
        }

        .footer-right {
            display: flex;
            gap: 10px;
        }

        button.download__pdf_btn {
            background: #000;
            color: white;
            font-weight: 600;
            padding: 7px;
            border-radius: 3px;
            margin-top: 20px;
            cursor: pointer;
        }

        .main__btn_dwn {
            text-align: end;
        }

        img {
            -webkit-user-drag: none;
            user-drag: none;
            pointer-events: auto;
        }

        .signature img {
            pointer-events: none;
            user-drag: none;
            -webkit-user-drag: none;
        }

        .digital__signature {
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
        }

        .allow__img {
            -webkit-user-drag: auto !important;
            user-drag: auto !important;
            pointer-events: auto !important;
            user-select: auto !important;
            -webkit-user-select: auto !important;
        }

        span.normal_text {
            font-weight: 500;
        }

        h2.att_name {
            line-height: 17px;
            font-size: 21px;
        }

        h2.att_designation {
            font-size: 22px;
            line-height: 30px;
            width: 235px;
            margin: 0 auto;
            text-align: center;
        }

        @media print {  
            .print-btn {  
                display: none;  
            }  
            .verification-status {  
                display: none;  
            }  
            title{  
                display: none;  
            }  
             
            body {  
                background: #fff !important;  
            }  

            .qr-code {  
                position: absolute;  
                bottom: 5mm;  
                right: 5mm;  
                width: 150px;  
                height: 150px;  
            }  

            .certificate {  
                width: 184mm;  
                height: 277mm;  
                padding: 10px 10px 10px 30px !important;  
                border: 1px solid #000;  
                background: #fff;  
                margin-left: -3px;  
                margin-top: -13px;   
            }  

            .section {  
                margin-top: 15px;  
                font-size: 18px;  
            }  

            .footer__data {  
                display:none;  
            }  

            .logo__section{  
                display:none  
            }  

            .app__style{  
                display:none;  
            }  

            .main__btn_dwn{  
                display:none;  
            }  

            .wrapper{  
                display:none;  
            }  

            .containers {  
                position: relative;  
                width: 147.32mm;  
                background: #ffffff;  
                height: 208.28mm;  
                box-shadow: none;  
                border-radius: 0px;  
                padding-top: 5px;  
                margin-left: 0px;  
                margin-bottom:0 !important;  
            }  

            .main__pdf__data{  
                border:none;  
            }

            .svg-watermark {
                opacity: 1 ;
                width: 100% ;
                height: 100% ;
            }

            .loader-overlay, #loader {
                display: none !important; /* প্রিন্ট করার সময় লোডার আড়াল করা */
            }
        }  
    </style>

</head>  
<body>  
    <div class="logo__section">  
        <img src="../assets/images/logo3.png" alt="">  
    </div>  

    <h3 class="app__style">অ্যাপোস্টিল</h3>  
  
    <div class="main__pdf__data">  
        <div class="containers">  

            <div class="loader-overlay" id="loader">
                <div class="loader"></div>
            </div>

            <div id="mainContent" style="display: none;">
                <div class="certificate">  
                    <?php if ($apostille && !empty($svgContent)): ?>
                        <div class="svg-watermark">
                            <?php echo $svgContent; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($apostille): ?>   

                    <?php else: ?>  
                        <div class="verification-status verification-error" style="position: relative; z-index: 1;">  
                            ✗ VERIFICATION FAILED  
                        </div>  
                          
                        <div class="error-certificate" style="position: relative; z-index: 1;">  
                            <div>  
                                <h2>E-Apostille Verification Failed</h2>  
                                <p><?php echo htmlspecialchars($error); ?></p>  
                                <p style="font-size: 14px; margin-top: 20px;">  
                                    Please check your verification link or contact the issuing authority.  
                                </p>  
                            </div>  
                        </div>  
                    <?php endif; ?>  
                </div>
            </div>
        </div>  
    </div>  
    
<?php if ($apostille): ?>  
    <div class="main__btn_dwn">  
        <button class="download__pdf_btn" onclick="printSVG()">  
            <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="mr-4" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">  
                <path d="M216 0h80c13.3 0 24 10.7 24 24v168h87.7c17.8 0 26.7 21.5 14.1 34.1L269.7 378.3c-7.5 7.5-19.8 7.5-27.3 0L90.1 226.1c-12.6-12.6-3.7-34.1 14.1-34.1H192V24c0-13.3 10.7-24 24-24zm296 376v112c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V376c0-13.3 10.7-24 24-24h146.7l49 49c20.1 20.1 52.5 20.1 72.6 0l49-49H488c13.3 0 24 10.7 24 24zm-124 88c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20zm64 0c0-11-9-20-20-20s-20 9-20 20 9 20 20 20 20-9 20-20z"></path>  
            </svg>  
            অ্যাপোস্টিল ডাউনলোড 
        </button>  
    </div>  

    <!-- এইখানে 'hidden' ক্লাস যোগ করা হয়েছে -->
<div id="apostille_svg" style="position: absolute; left: -9999px; width: 1px; height: 1px; overflow: hidden;">
    <?php echo $svgContent; ?>
</div>

    <script>
    function printSVG() {
        const svgContainer = document.getElementById("apostille_svg");
        if (!svgContainer) return;

        const svgHTML = svgContainer.outerHTML;

        // প্রিন্ট সেটআপ
        const printWindow = window.open('', '_self');
        printWindow.document.write(`
            <html>
                <head>
                    <title>Print Apostille</title>
                    <style>
                        @page {
                            size: A4 portrait; /* ✅ পেপার সাইজ A4 */
                            margin: 10mm;
                        }
                        body {
                            margin: 0;
                            padding: 0;
                            display: flex;
                            justify-content: center;
                            align-items: center;
                        }
                        svg {
                            width: 100%;
                            height: auto;
                        }
                        #apostille_svg {
    position: static !important;
    left: auto !important;
    width: 100% !important;
    height: auto !important;
    overflow: visible !important;
}
                    </style>
                </head>
                <body>${svgHTML}</body>
            </html>
        `);
        printWindow.document.close();
        printWindow.focus();
        window.print();
    }
    </script>  
<?php endif; ?>

    <?php if ($apostille): ?>  
        <div class="footer__data">  
            <h3>সনদপত্র/নম্বরপত্র/একাডেমিক ট্রান্সক্রিপ্ট/ডকুমেন্টস</h3>  
            <div class="scancopyv1">
            <div class="main__sign_data">  
                <?php if (!empty($apostille['front_part_scan_copy'])): ?>  
                    <img class="main__signature" src="https://pcc.police.gov.bd.ords.pw/<?php echo htmlspecialchars($apostille['front_part_scan_copy']); ?>" alt="" >  
                <?php endif; ?>  
            </div>  
            <div class="foooter__datas">  
                <img class="main__signed" src="../assets/images/sign1.png" alt="" >  
                <?php if (!empty($apostille['dsb_sign_image'])): ?>  
                    <img class="main__signatured allow__img" src="https://pcc.police.gov.bd.ords.pw/<?php echo htmlspecialchars($apostille['dsb_sign_image']); ?>" alt="" >  
                <?php endif; ?>  
                  
                <h2 class="margin_bottom"><?php echo date('d-M-Y', strtotime($apostille['dsb_signature_date'])); ?></h2>  
                <h2><?php echo htmlspecialchars($apostille['signed_by_sp']); ?></h2>  
                <h2><?php echo htmlspecialchars($apostille['superintendent']); ?></h2>  
            </div>  
        </div> 
        </div>
    <?php endif; ?>  

    <div class="wrapper">  
        <footer class="footer">  
            <div class="footer-container">  
                <div class="footer-left">  
                    <div class="logo__image__footer">   
                        <img src="../assets/images/logo4.png" class="logo" alt="">  
                    </div>  
                    <div class="left____data">  
                        <p class="copyright">কপিরাইট © ২০২৫ সর্বস্বত্ব সংরক্ষিত</p>  
                        <p class="gov-info">গণপ্রজাতন্ত্রী বাংলাদেশ সরকার</p>  
                    </div>  
                </div>  
                <div class="footer-right">  
                    <div class="right____text"><p>পরিকল্পনা বাস্তবায়নে</p></div>  
                    <img src="../assets/images/logo5.png" class="logo-small" alt="">  
                </div>  
            </div>  
        </footer>  
    </div>  

    <script>  
        document.addEventListener("dragstart", function(event) {  
            event.preventDefault();  
        });  
          
        document.addEventListener("contextmenu", function(event) {  
            if (event.target.tagName === "IMG") {  
                event.preventDefault();  
            }  
        });  

        document.addEventListener("DOMContentLoaded", function() {  
            if (document.querySelector('.digital__signature')) {  
                document.querySelector('.digital__signature').onselectstart = function() {  
                    return false;  
                };  
            }  

            // --- লোডার JavaScript ---
            const apostilleFound = <?php echo json_encode((bool)$apostille); ?>;
            const hasError = "<?php echo $error; ?>";
            
            if (apostilleFound || hasError) {
                setTimeout(() => {
                    const loader = document.getElementById("loader");
                    const mainContent = document.getElementById("mainContent");

                    if (loader) {
                        loader.style.display = "none";
                    }
                    if (mainContent) {
                        mainContent.style.display = "block";
                    }
                }, 1000); // 1000ms ডিলে
            }
            // --- লোডার JavaScript ---

        });  

        function printWithPassNumber(passNumber) {  
            const originalTitle = document.title;  
            document.title = passNumber + ' - Verified';  

            setTimeout(() => {  
                window.print();  
                setTimeout(() => {  
                    document.title = originalTitle;  
                }, 1000);  
            }, 300);  
        }  

    </script>

</body>  
</html>
