<?php
// includes/functions.php - All system functions
if (!function_exists('isLoggedIn')) {
    function isLoggedIn() {
        return isset($_SESSION['alogin']) && !empty($_SESSION['alogin']);
    }
}

if (!function_exists('isAdmin')) {
    function isAdmin() {
        return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
    }
}

if (!function_exists('requireLogin')) {
    function requireLogin() {
        if (!isLoggedIn()) {
            header('Location: login.php');
            exit();
        }
    }
}

if (!function_exists('requireAdmin')) {
    function requireAdmin() {
        requireLogin();
        if (!isAdmin()) {
            header('Location: dashboard.php');
            exit();
        }
    }
}

if (!function_exists('validateCSRF')) {
    function validateCSRF($token) {
        return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
    }
}

if (!function_exists('generateRefNo')) {
    function generateRefNo($link) {
        do {
            $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            $ref = '1C';
            for ($i = 0; $i < 5; $i++) {
                $ref .= $chars[rand(0, strlen($chars) - 1)];
            }
            
            // Check if this reference number already exists
            $check_sql = "SELECT id FROM pcc_log WHERE ref_no = ?";
            $check_stmt = mysqli_prepare($link, $check_sql);
            if ($check_stmt) {
                mysqli_stmt_bind_param($check_stmt, "s", $ref);
                mysqli_stmt_execute($check_stmt);
                $check_result = mysqli_stmt_get_result($check_stmt);
                $exists = mysqli_num_rows($check_result) > 0;
                mysqli_stmt_close($check_stmt);
            } else {
                $exists = false;
            }
        } while ($exists);
        
        return $ref;
    }
}
?>