<?php
// includes/header.php
$user_email = $_SESSION['alogin'];
$user_name = $_SESSION['name'] ?? 'User';
$user_role = $_SESSION['role'] ?? 'user';
?>
<header class="app-header header-profile">
    <nav class="navbar navbar-expand-lg navbar-light px-2 px-md-3">
        <!-- Left side - Hamburger menu -->
        <div class="navbar-brand">
            <a class="nav-link sidebartoggler nav-icon-hover" id="headerCollapse" href="javascript:void(0)">
                <i class="fas fa-bars"></i>
            </a>
        </div>

        <!-- Right side - User profile -->
        <div class="ms-auto">
            <div class="dropdown">
                <a class="nav-link nav-icon-hover d-flex align-items-center user-profile-dropdown" 
                   href="javascript:void(0)" id="drop2" data-bs-toggle="dropdown" aria-expanded="false">
                    
                    <!-- Lottie animation -->
                    <dotlottie-wc 
                        src="https://lottie.host/8068e607-434c-4320-b38e-de821de7762e/PDYyJvcETZ.lottie" 
                        class="user-avatar" 
                        autoplay 
                        speed="2.5" 
                        loop>
                    </dotlottie-wc>

                    <!-- User name & role -->
                    <div class="user-info ms-2">
                        <div class="user-name"><?php echo htmlspecialchars($user_name); ?></div>
                        <div class="user-role"><?php echo ucfirst($user_role); ?></div>
                    </div>
                </a>
                
                <div class="dropdown-menu dropdown-menu-end dropdown-menu-animate-up" aria-labelledby="drop2">
                    <div class="message-body">
                        <a href="profile.php" class="d-flex align-items-center gap-2 dropdown-item">
                            <i class="fas fa-user fs-6"></i>
                            <p class="mb-0 fs-3">My Profile</p>
                        </a>
                        <a href="logout.php" class="btn btn-outline-primary mx-3 mt-2 d-block">Logout</a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
</header>

<!-- Sidebar overlay for mobile -->
<div class="sidebar-overlay d-lg-none" id="sidebarOverlay"></div>

<style>
/* Base header styles */
.app-header {
    background: #fff;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    position: sticky;
    top: 0;
    z-index: 1030;
    margin: 0;
    padding: 0;
}

.navbar {
    padding: 0;
    min-height: 60px;
    align-items: center;
    margin: 0;
}

/* Hamburger menu */
.sidebartoggler {
    display: flex !important;
    align-items: center;
    justify-content: center;
    padding: 12px 16px !important;
    border-radius: 8px;
    transition: all 0.3s ease;
    color: #333 !important;
    text-decoration: none;
    min-width: 50px;
    min-height: 50px;
}

.sidebartoggler:hover {
    background: rgba(102, 126, 234, 0.1);
    color: #667eea !important;
}

.sidebartoggler i {
    font-size: 1.5rem;
}

/* User profile dropdown */
.user-profile-dropdown {
    display: flex !important;
    align-items: center;
    padding: 8px 12px;
    border-radius: 10px;
    transition: all 0.3s ease;
    text-decoration: none;
    color: inherit;
    min-height: 50px;
}

.user-profile-dropdown:hover {
    background: rgba(102, 126, 234, 0.1);
    text-decoration: none;
    color: inherit;
}

/* User avatar */
.user-avatar {
    width: 50px !important;
    height: 50px !important;
    border-radius: 50%;
    flex-shrink: 0;
    border: 2px solid #e9ecef;
}

/* User info */
.user-info {
    display: flex !important;
    flex-direction: column !important;
    justify-content: center !important;
    min-width: 0 !important;
    line-height: 1.2 !important;
    margin-left: 8px !important;
}

.user-name {
    font-weight: 600 !important;
    font-size: 0.95rem !important;
    color: #333 !important;
    margin: 0 !important;
    padding: 0 !important;
    white-space: nowrap !important;
    overflow: hidden !important;
    text-overflow: ellipsis !important;
    max-width: 150px !important;
    display: block !important;
    visibility: visible !important;
}

.user-role {
    font-size: 0.8rem !important;
    color: #6c757d !important;
    margin: 0 !important;
    padding: 0 !important;
    text-transform: capitalize !important;
    white-space: nowrap !important;
    display: block !important;
    visibility: visible !important;
}

/* Sidebar overlay */
.sidebar-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    z-index: 1039;
    display: none;
}

.sidebar-overlay.show {
    display: block;
}

/* Mobile responsive styles */
@media (max-width: 1199.98px) {
    .left-sidebar {
        transform: translateX(-100%);
        transition: transform 0.3s ease;
    }
    
    .left-sidebar.show {
        transform: translateX(0);
    }
    
    .body-wrapper {
        margin-left: 0;
    }
    
    .app-header {
        left: 0;
        width: 100%;
    }
}

/* Mobile phone styles */
@media (max-width: 767.98px) {
    .navbar {
        min-height: 55px !important;
        padding: 0 0.5rem !important;
    }
    
    .app-header {
        padding: 0 !important;
        margin: 0 !important;
    }
    
    /* Hamburger adjustments */
    .sidebartoggler {
        padding: 8px 12px !important;
        min-width: 40px !important;
        min-height: 40px !important;
    }
    
    .sidebartoggler i {
        font-size: 1.3rem !important;
    }
    
    /* User profile adjustments */
    .user-avatar {
        width: 40px !important;
        height: 40px !important;
    }
    
    .user-info {
        display: flex !important;
        flex-direction: column !important;
        margin-left: 8px !important;
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    .user-name {
        font-size: 0.85rem !important;
        max-width: 110px !important;
        display: block !important;
        visibility: visible !important;
        color: #333 !important;
        font-weight: 600 !important;
    }
    
    .user-role {
        font-size: 0.7rem !important;
        display: block !important;
        visibility: visible !important;
        color: #6c757d !important;
    }
    
    .user-profile-dropdown {
        padding: 4px 8px !important;
        min-height: 40px !important;
        display: flex !important;
        align-items: center !important;
    }
}

/* Very small phones */
@media (max-width: 575.98px) {
    .navbar {
        min-height: 50px !important;
        padding: 0 0.25rem !important;
    }
    
    .app-header {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .sidebartoggler {
        padding: 6px 10px !important;
        min-width: 36px !important;
        min-height: 36px !important;
    }
    
    .sidebartoggler i {
        font-size: 1.2rem !important;
    }
    
    .user-avatar {
        width: 36px !important;
        height: 36px !important;
    }
    
    .user-info {
        margin-left: 6px !important;
        display: flex !important;
        flex-direction: column !important;
        visibility: visible !important;
        opacity: 1 !important;
    }
    
    .user-name {
        font-size: 0.8rem !important;
        max-width: 90px !important;
        display: block !important;
        visibility: visible !important;
        line-height: 1.1 !important;
    }
    
    .user-role {
        font-size: 0.65rem !important;
        display: block !important;
        visibility: visible !important;
        line-height: 1.1 !important;
    }
    
    .user-profile-dropdown {
        padding: 3px 6px !important;
        min-height: 36px !important;
        display: flex !important;
        align-items: center !important;
    }
}

/* Extra small screens */
@media (max-width: 360px) {
    .navbar {
        min-height: 48px !important;
    }
    
    .user-name {
        max-width: 75px !important;
        font-size: 0.75rem !important;
    }
    
    .user-role {
        font-size: 0.6rem !important;
    }
    
    .user-avatar {
        width: 32px !important;
        height: 32px !important;
    }
    
    .user-info {
        margin-left: 5px !important;
    }
    
    .sidebartoggler {
        min-width: 32px !important;
        min-height: 32px !important;
        padding: 5px 8px !important;
    }
}

/* Dropdown menu responsive */
.dropdown-menu {
    border: 1px solid #e9ecef;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

@media (max-width: 575.98px) {
    .dropdown-menu {
        min-width: 180px;
        right: 0.5rem !important;
        left: auto !important;
    }
}

/* Ensure flexbox works properly */
.d-flex {
    display: flex !important;
}

.align-items-center {
    align-items: center !important;
}

.ms-auto {
    margin-left: auto !important;
}

.ms-2 {
    margin-left: 0.5rem !important;
}
</style>

<!-- Load lottie player -->
<script src="https://unpkg.com/@lottiefiles/dotlottie-wc@0.8.1/dist/dotlottie-wc.js" type="module"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const sidebarToggler = document.getElementById('headerCollapse');
    const sidebar = document.querySelector('.left-sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    
    if (sidebarToggler && sidebar && overlay) {
        // Toggle sidebar
        sidebarToggler.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            sidebar.classList.toggle('show');
            overlay.classList.toggle('show');
        });
        
        // Close sidebar when clicking overlay
        overlay.addEventListener('click', function() {
            sidebar.classList.remove('show');
            overlay.classList.remove('show');
        });
        
        // Close sidebar on window resize if screen becomes large
        window.addEventListener('resize', function() {
            if (window.innerWidth >= 1200) {
                sidebar.classList.remove('show');
                overlay.classList.remove('show');
            }
        });
        
        // Close sidebar when clicking on sidebar links (mobile only)
        const sidebarLinks = document.querySelectorAll('.sidebar-link, .sidebar-nav a');
        sidebarLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth < 1200) {
                    sidebar.classList.remove('show');
                    overlay.classList.remove('show');
                }
            });
        });
    }
    
    // Debug: Check if elements are present
    console.log('Header elements:', {
        hamburger: !!sidebarToggler,
        sidebar: !!sidebar,
        overlay: !!overlay,
        userProfile: !!document.querySelector('.user-profile-dropdown')
    });
});
</script>