<?php
// includes/html-header.php
require_once('config.php');
require_once('db.php');

if (!isLoggedIn()) {
    header('Location: login.php');
    exit();
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo SITE_NAME; ?></title>
    <link rel="shortcut icon" type="image/png" href="assets/images/logos/favicon.png" />
    <link rel="stylesheet" href="assets/css/styles.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .page-wrapper {
            min-height: 100vh;
        }
        .sidebar-nav {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .left-sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: 270px;
            height: 100vh;
            z-index: 1040;
            transition: all 0.3s ease;
        }
        
        /* Mobile responsiveness */
        @media (max-width: 1199.98px) {
            .left-sidebar {
                transform: translateX(-100%);
            }
            
            .left-sidebar.show {
                transform: translateX(0);
            }
            
            .body-wrapper {
                margin-left: 0 !important;
            }
            
            .app-header {
                left: 0 !important;
            }
        }
        .sidebar-item .sidebar-link {
            color: rgba(255,255,255,0.8);
            padding: 12px 20px;
            display: flex;
            align-items: center;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        .sidebar-item .sidebar-link:hover,
        .sidebar-item .sidebar-link.active {
            background: rgba(255,255,255,0.1);
            color: #fff;
            border-radius: 8px;
            margin: 0 10px;
        }
        .sidebar-item .sidebar-link i {
            margin-right: 10px;
            width: 20px;
        }
        .brand-logo {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .brand-logo h4 {
            color: #fff;
            margin: 0;
            font-weight: 600;
        }
        .header-profile {
            background: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-radius: 10px;
        }
        .btn-primary {
            background: linear-gradient(45deg, #667eea, #764ba2);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(45deg, #5a6fd8, #6a4190);
        }
        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px;
            padding: 20px;
            text-align: center;
        }
        .stats-card h3 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        .marquee-notice {
            background: linear-gradient(45deg, #343a40, #495057);
            color: white;
            padding: 10px;
            border-radius: 5px;
        }
    </style>
</head>