<?php
// includes/sidebar.php
$current_page = basename($_SERVER['PHP_SELF']);
?>
<aside class="left-sidebar">
    <div>
        <div class="brand-logo d-flex align-items-center justify-content-between">
            <div>
                <h4 class="text-nowrap logo-img"E Apostille System</h4>
            </div>
            <div class="close-btn d-xl-none d-block sidebartoggler cursor-pointer" id="sidebarCollapse">
                <i class="ti ti-x fs-8"></i>
            </div>
        </div>
        
        <nav class="sidebar-nav scroll-sidebar" data-simplebar="">
            <ul id="sidebarnav">
                <li class="nav-small-cap">
                    <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                    <span class="hide-menu">Home</span>
                </li>
                
                <li class="sidebar-item">
                    <a class="sidebar-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" 
                       href="dashboard.php" aria-expanded="false">
                        <span>
                            <i class="fas fa-tachometer-alt"></i>
                        </span>
                        <span class="hide-menu">Dashboard</span>
                    </a>
                </li>


                <li class="nav-small-cap">
                    <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                    <span class="hide-menu">E-Apostille (2)</span>
                </li>
                
                <li class="sidebar-item">
                    <a class="sidebar-link" <?php echo ($current_page == 'make_apostille.php') ? 'active' : ''; ?>" 
                       href="make_apostille.php" aria-expanded="false">
                        <span>
                            <i class="fas fa-plus-circle"></i>
                        </span>
                        <span class="hide-menu">Create</span>
                    </a>
                </li>

                
                <li class="sidebar-item">
                    <a class="sidebar-link" <?php echo ($current_page == 'manage_apostille') ? 'active' : ''; ?>" 
                       href="manage_apostille.php" aria-expanded="false">
                        <span>
                            <i class="fas fa-cogs"></i>
                        </span>
                        <span class="hide-menu">Manage</span>
                    </a>
                </li>
                
                <?php if (isAdmin()): ?>
                <li class="nav-small-cap">
                    <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                    <span class="hide-menu">User Management</span>
                </li>
                
                <li class="sidebar-item">
                    <a class="sidebar-link <?php echo ($current_page == 'add_user.php') ? 'active' : ''; ?>" 
                       href="add_user.php" aria-expanded="false">
                        <span>
                            <i class="fas fa-user-plus"></i>
                        </span>
                        <span class="hide-menu">Add User</span>
                    </a>
                </li>
                
                <li class="sidebar-item">
                    <a class="sidebar-link <?php echo ($current_page == 'manage_users.php') ? 'active' : ''; ?>" 
                       href="manage_users.php" aria-expanded="false">
                        <span>
                            <i class="fas fa-users-cog"></i>
                        </span>
                        <span class="hide-menu">Manage Users</span>
                    </a>
                </li>
                <?php endif; ?>

                <li class="nav-small-cap">
                    <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                    <span class="hide-menu">Account</span>
                </li>
                
                <li class="sidebar-item">
                    <a class="sidebar-link" href="logout.php" aria-expanded="false">
                        <span>
                            <i class="fas fa-sign-out-alt"></i>
                        </span>
                        <span class="hide-menu">Logout</span>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
</aside>